#!/bin/sh
#
# This is a generic install script, 
#

if [ $# != 1 ]
then
    echo "You must supply the OS version number as an argument (e.g., 30)."
    exit 1
fi
#
# Define a shell function to ask questions of the user.
#
# 0 is returned for "Yes" and its variants
# 1 is returned for "No"  and its variants.
#
ask_yes()
{
    echo "$* (Yes/No): \c"

    while true
    do
	read answer discard

	#
	# See if answer is non-null.
	# A new-line is defaulted to a yes.
	#
	if test "$answer" = ""
	then
	    return 0
	fi

	#
	# Check for yes or no,  If response is not recognized,
	# prompt use and read again the user's response.
	#
	case $answer in
	  Y) return 0;;
	  y) return 0;;
	  Yes) return 0;;
	  yes) return 0;;
	  N) return 1;;
	  n) return 1;;
	  No) return 1;;
	  no) return 1;;
	  q) return 1;;
	  Q) return 1;;
	  *) echo "Please answer Y or N: \c"
	     continue;;
	esac
    done;
}


#
# A function called in response to install failure
#
cleanup()
{
    ./Remove
    exit 1
}

clear

OSVER=$1

case "$OSVER"
in
"24") OSRANGE="24-27";;
"25") OSRANGE="24-27";;
"26") OSRANGE="24-27";;
"27") OSRANGE="24-27";;
"28") OSRANGE="28-33";;
"29") OSRANGE="28-33";;
"30") OSRANGE="28-33";;
"31") OSRANGE="28-33";;
"32") OSRANGE="28-33";;
"33") OSRANGE="28-33";;
*       ) echo No OS version match. You can only use Linux versions 2.0.24-2.0.33
	  exit 1;;
esac

NPWD=`pwd`
echo ""
echo "You are about to install the Streams subsystem and semaphore patches to"
echo "the Linux 2.0.$OSVER kernel."
echo ""
echo "This installation assumes that the kernel is linked beneath the /usr/src/linux"
echo "directory. If this is not the source pointed to by /usr/src/linux, please"
echo "set up the symbolic link now (e.g., ln -s /usr/src/linux-2.0.$OSVER /usr/src/linux)."
echo ""
echo "When you have verified this, press ENTER"
read XX

echo "Testing to see if the semaphore patch is needed."

cd /usr/src/linux

grep -s Grothe /usr/src/linux/include/asm-i386/semaphore.h > /dev/null 2>&1

if [ "$?" != "0" ]
then
   echo "The semaphore patch needs to be added to your system. Updating the kernel"
   echo "now."
   patch -p1 < $NPWD/patches.semaphores > /tmp/plog 2>&1
   grep -s fail /tmp/plog
   if [ "$?" = "0" ]
   then
      echo "An error was detected when patching the sourc for the semaphores."
      echo "Please check the file /tmp/plog and fix the problem if possible."
      exit 1
   fi
   echo "The semaphore patch was successful."
else
  echo "The semaphore patch is not needed on this system."
fi

echo

# go to the source area and patch the kernel
echo "Adding the kernel patch to the system."

/usr/bin/patch -p1 < $NPWD/patches.kernel.$OSRANGE > /tmp/plog 2>&1
grep -s fail /tmp/plog > /dev/null 2>&1
if [ $? = 0 ]
then
    echo "The kernel patch was unsuccessful. Please review the /tmp/plog file to"
    echo "determine when the failure occurred."
    exit 1
else
    echo "The kernel patch was successfully added to the kernel."
fi

#
# Add the streams patch to this system if needed
#

if [ ! -d /usr/src/linux/drivers/streams ]
then
    echo "Adding the STREAMS patch to the OS."
    cd /usr/src/linux
    /usr/bin/patch -p1 < $NPWD/patches.streams > /tmp/log 2>&1
   grep -s fail /tmp/plog > /dev/null 2>&1
   if [ $? = 0 ]
   then
      echo "The kernel has been patched and the patch log resides in /tmp/log."
      echo "The log indicates an error occurred. Please check the file /tmp/log"
      echo "to determine the nature of the failure."
      exit 1
   else
        echo "The STREAMS patch was successfully added to the kernel."
   fi
else
    echo "The kernel you have already contains the STREAMS subsystem. You must"
    echo "ensure that it is at least version 1.6"

    YY=`grep lis_version /usr/src/linux/drivers/streams/LiS/head/version.c`

    echo "Your version is $YY. Is it greater than 1.6 (y|n)?"
    read XX
    case "$XX"
    in
        "N"|"n") echo "Please update your streams version or replace the kernel source"
             echo "tree with a version that does not have the streams patch and"
             echo "then start this process over."
	     exit 1 ;;
    esac
    
    echo "You have indicated that the streams source located in your kernel is"
    echo "to be used."
fi


cd $NPWD

echo "Installing the util directory under /usr/src/linux/drivers/streams/LiS."

cp -r /usr/src/gcom/util /usr/src/linux/drivers/streams/LiS/util

echo "You are now ready to compile the STREAMS subsystem."
echo "Continue with the instructions in the README.PATCH file."
exit 0
